/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class TimeUnitListCellRenderer
extends DefaultListCellRenderer {
    public static final String HIGH_UNIT = "highValue";
    public static final String LOW_UNIT = "lowValue";
    private String fDisplayedUnit;
    boolean fShowAbbreviation = true;

    public TimeUnitListCellRenderer() {
        this.fShowAbbreviation = false;
        this.fDisplayedUnit = HIGH_UNIT;
    }

    public TimeUnitListCellRenderer(boolean showAbbreviation) {
        this.fShowAbbreviation = showAbbreviation;
    }

    public TimeUnitListCellRenderer(boolean showAbbreviation, String unit) {
        this.fDisplayedUnit = unit;
        this.fShowAbbreviation = showAbbreviation;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof TimeUnit) {
            TimeUnit timeUnit = (TimeUnit)value;
            String unitText = "";
            if (this.fShowAbbreviation) {
                unitText = this.fDisplayedUnit == LOW_UNIT ? timeUnit.getLowValueUnitAbbreviation() : timeUnit.getUnitAbbreviation();
            } else if (this.fDisplayedUnit == LOW_UNIT) {
                String key1 = timeUnit.getUnitKey();
                String key = key1.startsWith("dialog.timeParameter.unlimitedHours") ? "dialog.timeParameter.hours" : timeUnit.getLowValueUnitKey();
                unitText = Language.getString(key, key);
                int bracketPosition = unitText.indexOf(40);
                if (bracketPosition != -1) {
                    unitText = unitText.substring(0, bracketPosition - 1);
                }
            } else {
                String key = timeUnit.getUnitKey();
                if (key.startsWith("dialog.timeParameter.unlimitedHours")) {
                    key = "dialog.timeParameter.hours";
                    unitText = Language.getString(key, key);
                } else {
                    unitText = Language.getString(key, key);
                }
            }
            this.setText(unitText);
        } else {
            this.setText(value.toString());
        }
        return this;
    }
}

